/* Antarmuka dengan Sensor RFID - Basic IoT Kit ESP32
 * Project : Security Lock Door
 * Created By Electins.id
 * https://www.electins.id | https://www.instagram.com/electins.id/
 */

// Library ESP32 WiFi dan Firebase ESP32
#include <WiFi.h>
#include <FirebaseESP32.h>

// Library OLED Display
#include <Wire.h>
#include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>

// Mengatur OLED Display dengan resolusi 128x64
#define SCREEN_WIDTH 128
#define SCREEN_HEIGHT 64
#define OLED_RESET    -1
Adafruit_SSD1306 display(SCREEN_WIDTH, SCREEN_HEIGHT, &Wire, OLED_RESET);

// Library RFID MFRC522
#include <SPI.h>
#include <MFRC522.h>

// Koneksi PIN RFID ke PIN NodeMCU
// RST/Reset   RST          5
// SPI SS      SDA(SS)      4
// SPI MOSI    MOSI         23 
// SPI MISO    MISO         19
// SPI SCK     SCK          18

#define RST_PIN 5
#define SS_PIN  4

#define RL_PIN   2
#define BUZZ_PIN 15

// SSID dan Password WiFi
#define WIFI_SSID "SSID_WIFI"
#define WIFI_PASSWORD "PASS_WIFI"

// URL Firebase dan Token Database
#define DATABASE_URL "project_id.firebaseio.com"
#define API_KEY "database_secret"

// Firebase objek dengan nama fbdo
FirebaseData fbdo;

// Nama pengguna pada Aplikasi IoT KIT
String user = "user_id";
// MFRC522 Objek dengan nama mrfc522
MFRC522 mfrc522(SS_PIN, RST_PIN);

// Variabel untuk menampung NUID kartu
String nuid;
String rfid_tag = "33e821fb"; 

void setup() {
  // Serial Monitor pada baudrate 115200
  Serial.begin(115200);
  
  // Mengatur BUZZ_PIN dan RL_PIN sebagai Output
  // Kondisi awal BUZZ_PIN dan RL_PIN LOW (Buzzer dan Relay OFF)
  pinMode(BUZZ_PIN, OUTPUT); digitalWrite(BUZZ_PIN, LOW);
  pinMode(RL_PIN, OUTPUT); digitalWrite(RL_PIN, LOW);
  
  // Memulai komunikasi dengan OLED Display
  display.begin(SSD1306_SWITCHCAPVCC, 0x3C);

  SPI.begin();        // Memulai komunikasi SPI dengan RFID
  mfrc522.PCD_Init(); // Inisialisasi RFID 
  
  // Memulai koneksi WiFi
  WiFi.begin(WIFI_SSID, WIFI_PASSWORD);
  Serial.print("Connecting to Wi-Fi");
  while (WiFi.status() != WL_CONNECTED)
  {
    Serial.print(".");
    delay(300);
  }
  // Menampilkan status koneksi dan alamat IP
  Serial.println();
  Serial.print("Connected with IP: ");
  Serial.println(WiFi.localIP());
  Serial.println();
  
  // Menampilkan versi client firebase
  Serial.printf("Firebase Client v%s\n\n", FIREBASE_CLIENT_VERSION);
  // Memulai koneksi dengan dengan database
  // Re-koneksi jika WiFi terputus
  Firebase.begin(DATABASE_URL, API_KEY);
  Firebase.reconnectWiFi(true);

  // Membersihkan tampilan display
  display.clearDisplay();
}

void loop() { 
  display.clearDisplay();       // Membersihkan tampilan display
  // Menampilkan data pada OLED Display
  display.setTextSize(1);  display.setTextColor(WHITE);
  display.setCursor(1,1);  display.print("Scan Card");
  display.setTextSize(1);  display.setTextColor(WHITE);
  display.setCursor(1,10); display.print("NUID: ");

  display.setTextSize(1);       // Mengatur ukuran teks = 1
  display.setTextColor(WHITE);  // Mengatur teks warna putih
  display.setCursor(0,20);      // Mengatur kursor (x:0, y:20)
  display.print("Status :");    // Mencetak Teks "Status"
  display.display();

  // Membaca database pada alamat */user/switch1
  // Jika bernilai true Relay ON
  // Jika bernilai false Relay OFF
  if(Firebase.getString(fbdo, "/" + user +  "/switch1")) {
    if(fbdo.to<bool>() == true){
      digitalWrite(RL_PIN, HIGH);
      Serial.println("Relay ON");
    }else{
      digitalWrite(RL_PIN, LOW);
      Serial.println("Relay OFF");
    }
  }
  
  // Membaca dan verifikasi kartu
  if(!mfrc522.PICC_IsNewCardPresent()) { return; }
  if(!mfrc522.PICC_ReadCardSerial())   { return; }
  Serial.print("UID tag : ");
  String tag_id;

  // NUID disatukan dan disimpan pada 'tag_id'
  for(byte i = 0; i < mfrc522.uid.size; i++) {
     tag_id.concat(String(mfrc522.uid.uidByte[i], HEX));
  }
  // Menyimpan NUID ke variabel global 'nuid'
  nuid = tag_id;

  display.setTextSize(1);  display.setTextColor(WHITE);
  display.setCursor(35,10); display.print(nuid);
  display.display(); // Menampilkan data
  Serial.println(nuid);

  // Pencocokan NUID yang tersimpan dengan yang terbaca
  // Nada buzzer scan, kartu diterima dan ditolak 
  if(rfid_tag == nuid){
    buzz_auth();
    buzz_accepted();
  }else{
    buzz_auth();
    buzz_denied();
  }
}

// Fungsi Nada Buzzer scan kartu
void buzz_auth() {
  for (int x = 0; x < 8 ; x++ ) {
    digitalWrite(BUZZ_PIN, HIGH);
    delay(50);
    digitalWrite(BUZZ_PIN, LOW);
    delay(30);
    }
  delay(500);
}

// Fungsi Nada Buzzer akses diterima
void buzz_accepted() {
  // menampilkan teks ACC
  display.setTextSize(2);       // Mengatur ukuran teks = 2
  display.setCursor(0,35);      // Mengatur kursor (x:0, y:35)
  display.print("ACCEPT");      // Mencetak teks ACCEPT
  display.display();            // Menampilkan data

  for (int x = 0; x < 2 ; x++ ) {
    digitalWrite(BUZZ_PIN, HIGH);
    delay(200);
    digitalWrite(BUZZ_PIN, LOW);
    delay(100);
  }
  // Mengaktifkan relay selama 2 detik
  digitalWrite(RL_PIN, HIGH);
  delay(2000);
  // Mengirim data ke database
  Firebase.setString(fbdo, "/" + user + "/indicator1", nuid);
  Firebase.setString(fbdo, "/" + user + "/indicator2", "Akses diterima");

  digitalWrite(RL_PIN, LOW);
  delay(100);
}

// Fungsi Nada Buzzer akses ditolak
void buzz_denied() {
  display.setTextSize(2);       // Mengatur ukuran teks = 2
  display.setCursor(0,35);      // Mengatur kursor (x:0, y:35)
  display.print("DENY");        // Mencetak teks DENY
  display.display();            // Menampilkan data
  digitalWrite(BUZZ_PIN, HIGH);
  delay(1000);
  // Mengirim data ke database
  Firebase.setString(fbdo, "/" + user + "/indicator1", nuid);
  Firebase.setString(fbdo, "/" + user + "/indicator2", "Akses ditolak");
  
  digitalWrite(BUZZ_PIN, LOW);
  delay(100);
}